# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: Not Provided

def radiant_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early rounds: establish goodwill
    if current_round <= 3:
        if current_round == 1:
            return "C"
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Mid rounds: conditional cooperation
    if current_round <= 7:
        if len(opp_history) >= 2 and all(m == "C" for m in opp_history[-2:]):
            return "C"
        if "forgiveness" in opponent_program_code.lower() or "random" in opponent_program_code.lower():
            return "D"
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Late rounds: opportunistic defection
    if current_round >= 8:
        if "forgiveness" in opponent_program_code.lower() or "random" in opponent_program_code.lower():
            return "D"
        if len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "C":
            if current_round == total_rounds:
                return "D"
            return "C"
        return "D"
    
    # Fallback
    return "D"